﻿<%@ WebHandler Language="C#" Class="SqlHandler" %>

using System;
using System.Web;
using System.Web.SessionState;

public class SqlHandler : IHttpHandler, IRequiresSessionState
{
    public void ProcessRequest(HttpContext Context)
    {
        Chukeh.Data.IResult _Result;
        Chukeh.Data.IHash _Querys = Chukeh.Current.Querys;
        Chukeh.Data.SqlProvider _Provider = new Chukeh.Data.SqlProvider("SERVER=.;UID=sa;PWD=123456;DATABASE=test");
        switch (Context.Request.Params["Command"])
        {
            case "Add":
                if (Chukeh.Base.IsNull(Context.Request.Params["T_Name"]))
                {
                    Chukeh.Data.IResult.CurrentResult(new Chukeh.Data.IResult(3, "名称不能为空"));
                }
                else
                {
                    //  根据指定前缀拷贝哈希表
                    Chukeh.Data.IHash _AddQuerys = new Chukeh.Data.IHash();
                    _Querys.CopyByPrefix("T_", ref _AddQuerys);
                    //  执行插入操作
                    _Result = _Provider.RunInsert("DB_TABLE", true, false, _AddQuerys);
                    //  写入操作结果信息
                    Chukeh.Data.IResult.CurrentResult(_Result);
                }
                Context.Response.Redirect("List.aspx?d=" + DateTime.Now.Ticks.ToString("x"));
                break;
            case "Edit":
                //  根据指定前缀拷贝哈希表
                Chukeh.Data.IHash _EditQuerys = new Chukeh.Data.IHash();
                _Querys.CopyByPrefix("T_", ref _EditQuerys);
                //  执行插入操作
                _Result = _Provider.RunUpdate("DB_TABLE", true, false, _EditQuerys);
                //  写入操作结果信息
                Chukeh.Data.IResult.CurrentResult(_Result);
                //  跳转至列表页
                Context.Response.Redirect("List.aspx?d=" + DateTime.Now.Ticks.ToString("x"));
                break;
            case "Delete":
                //  执行插入操作
                _Result = _Provider.RunDelete("DB_TABLE", _Querys);
                //  写入操作结果信息
                Chukeh.Data.IResult.CurrentResult(_Result);
                //  跳转至列表页
                Context.Response.Redirect("List.aspx?d=" + DateTime.Now.Ticks.ToString("x"));
                break;
            default:
                break;
        }
        _Provider.Dispose();
    }

    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
}